%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Moving Infinite Line Source (MILSd): Metzger et al. 2004.               %
%                                      Molina-Giraldo et al. 2011         %
% Considering thermal dispersion                                          %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_MILSd(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
Dt = lm/Cm;                         % thermal diffusivity [m2/s]
Dx = Dt + ax*vT; Dy = Dt + ay*vT;	% Thermal dispersion coefficients
  
% Temperature change 
T = QL*(1/4/pi/Cm/sqrt(Dx*Dy))*exp(vT*x/2/Dx)*...
quadgk(@(psi) (1./psi).*exp(-psi-((x^2/Dx)+(y^2/Dy))*...
vT^2/16/Dx./psi),((x^2/4/Dx/t)+(y^2/4/Dy/t)),Inf);

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 
